{$A+,B-,D-,E+,F-,I+,L-,N-,O-,R+,S+,V+}
{$M 16384,0,0}

program MakeReserve;

{ A utility program to help update PXL with new Turbo Pascal reserved words.}
{ After you put new reserved words into PXL.WDS, run this program.  It will }
{                                                                           }
{  (a) read PXL.WDS,                                                        }
{  (b) create a file with the name given in constant TempFileName, below, & }
{  (c) write in it a new procedure IntWds4                                  }
{                                                                           }
{ Substitute this new procedure IntWds4 for the old IntWds4 in procedure    }
{ LoadReserv in PXLMENU.PAS.                                                }
{                                                                           }
{    This needs to be done, of course, only if you set DataFiles := False   }
{ (in PXL.PAS, procedure SetUp) to use PXL's internal data aboutr reserved  }
{ words and printer controls.                                               }

uses DOS,CRT,PXLINIT;
const
   TempFileName = 'INTWDS4.PAS';
type
   LineType = string[80];
var
   F:           text;
   NRes,K:      integer;
   ResWd:       array[1..100] of LineType;
   Line,St:     LineType;

   procedure Emit(L: LineType);
   begin
      writeln(F,L);
      writeln(L);
   end; {Emit}

begin
   assign(F,'PXL.WDS');
   reset(F);
   NRes := 0;
   while not Eof(F) do begin
      readln(F,St);
      if St<>'' then begin
         inc(NRes);
         ResWd[NRes] := Strip(InCapitals(St),[]);
      end; {if not empty}
   end; {while not Eof}
   if NRes=0 then begin
      Writeln('Huh?');
      halt
   end; {if none}
   close(F);
   assign(F,TempFileName);
   rewrite(F);
   Emit('   procedure IntWds4; {This version for TP 4 & 5}');
   Emit('   begin');
   Emit('      {if DataFiles = False, reserved words will be set thus:}');
   Emit('      NRes := ' + StrgI(NRes,1));
   for K := 1 to NRes do begin
      if Odd(K) then
         Line := '      Reserv[' + StrgI(K,1) + '] := ''' + ResWd[K] + ''';'
      else begin
         Line := PadOrChop(Line,39);
         Line := Line + 'Reserv[' + StrgI(K,1) + '] := ''' + ResWd[K] + ''';';
         Emit(Line);
      end {else even}
   end; {For K}
   if odd(NRes) then Emit(Line);
   Emit('   end; {IntWds4}');
   Emit(' ');
   close(F);
   writeln('All done.  New procedure IntWds4 is in ',TempFileName);
end.
